/*
 * Decompiled with CFR 0.152.
 */
package net.ftb.minecraft;

import com.google.common.collect.Lists;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.swing.ProgressMonitor;
import net.feed_the_beast.launcher.json.JsonFactory;
import net.feed_the_beast.launcher.json.assets.AssetIndex;
import net.feed_the_beast.launcher.json.versions.Library;
import net.feed_the_beast.launcher.json.versions.Version;
import net.ftb.data.LauncherStyle;
import net.ftb.data.LoginResponse;
import net.ftb.data.ModPack;
import net.ftb.data.Settings;
import net.ftb.download.info.DownloadInfo;
import net.ftb.download.workers.AssetDownloader;
import net.ftb.events.EnableObjectsEvent;
import net.ftb.gui.LaunchFrame;
import net.ftb.gui.panes.OptionsPane;
import net.ftb.log.LogEntry;
import net.ftb.log.LogLevel;
import net.ftb.log.Logger;
import net.ftb.log.StreamLogger;
import net.ftb.minecraft.MCLauncher;
import net.ftb.tools.ProcessMonitor;
import net.ftb.util.Benchmark;
import net.ftb.util.DownloadUtils;
import net.ftb.util.ErrorUtils;
import net.ftb.util.FileUtils;
import net.ftb.util.OSUtils;
import net.ftb.util.Parallel;
import net.ftb.util.TrackerUtils;

public class MCInstaller {
    public static void setupNewStyle(final String installPath, final ModPack pack, final boolean isLegacy, final LoginResponse RESPONSE) {
        List<DownloadInfo> assets = MCInstaller.gatherAssets(new File(installPath), pack.getMcVersion(Settings.getSettings().getPackVer(pack.getDir())), installPath);
        if (assets != null && assets.size() > 0) {
            Logger.logInfo("Checking/Downloading " + assets.size() + " assets, this may take a while...");
            final ProgressMonitor prog = new ProgressMonitor(LaunchFrame.getInstance(), "Downloading Files...", "", 0, 100);
            prog.setMaximum(assets.size() * 100);
            final AssetDownloader downloader = new AssetDownloader(prog, assets){

                @Override
                public void done() {
                    try {
                        prog.close();
                        if (((Boolean)this.get()).booleanValue()) {
                            Logger.logInfo("Asset downloading complete");
                            MCInstaller.launchMinecraft(installPath, pack, RESPONSE, isLegacy);
                        } else {
                            ErrorUtils.tossError("Error occurred during downloading the assets");
                        }
                    }
                    catch (CancellationException e) {
                        Logger.logInfo("Asset download interrupted by user");
                    }
                    catch (Exception e) {
                        ErrorUtils.tossError("Failed to download files.", e);
                    }
                    finally {
                        LaunchFrame.getInstance().getEventBus().post(new EnableObjectsEvent());
                    }
                }
            };
            downloader.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    if (prog.isCanceled()) {
                        downloader.cancel(false);
                        prog.close();
                    } else if (!downloader.isCancelled()) {
                        if ("ready".equals(evt.getPropertyName())) {
                            prog.setProgress(downloader.getReady());
                        }
                        if ("status".equals(evt.getPropertyName())) {
                            prog.setNote(downloader.getStatus());
                        }
                    }
                }
            });
            downloader.execute();
        } else if (assets == null) {
            LaunchFrame.getInstance().getEventBus().post(new EnableObjectsEvent());
        } else {
            MCInstaller.launchMinecraft(installPath, pack, RESPONSE, isLegacy);
        }
    }

    private static List<DownloadInfo> gatherAssets(final File root, String mcVersion, String installDir) {
        try {
            File test;
            Logger.logInfo("Checking local assets file, for MC version" + mcVersion + " Please wait! ");
            ArrayList<DownloadInfo> list = Lists.newArrayList();
            Boolean forceUpdate = Settings.getSettings().isForceUpdateEnabled();
            File local = new File(root, "versions/{MC_VER}/{MC_VER}.jar".replace("{MC_VER}", mcVersion));
            if (!local.exists() || forceUpdate.booleanValue()) {
                list.add(new DownloadInfo(new URL("https://s3.amazonaws.com/Minecraft.Download/" + "versions/{MC_VER}/{MC_VER}.jar".replace("{MC_VER}", mcVersion)), local, local.getName()));
            }
            Logger.logDebug("Checking minecraft.jar");
            URL url = new URL(DownloadUtils.getStaticCreeperhostLinkOrBackup("mcjsons/versions/{MC_VER}/{MC_VER}.json".replace("{MC_VER}", mcVersion), "https://s3.amazonaws.com/Minecraft.Download/" + "versions/{MC_VER}/{MC_VER}.json".replace("{MC_VER}", mcVersion)));
            File json = new File(root, "versions/{MC_VER}/{MC_VER}.json".replace("{MC_VER}", mcVersion));
            DownloadUtils.downloadToFile(url, json, 3);
            if (!json.exists()) {
                Logger.logError("library JSON not found");
                return null;
            }
            Version version = JsonFactory.loadVersion(json);
            Logger.logDebug("checking minecraft libraries");
            for (Library lib : version.getLibraries()) {
                if (lib.natives == null) {
                    local = new File(root, "libraries/" + lib.getPath());
                    if (local.exists() && !forceUpdate.booleanValue()) continue;
                    if (!lib.getUrl().toLowerCase().equalsIgnoreCase("maven/")) {
                        list.add(new DownloadInfo(new URL(lib.getUrl() + lib.getPath()), local, lib.getPath()));
                        continue;
                    }
                    list.add(new DownloadInfo(new URL(DownloadUtils.getCreeperhostLink(lib.getUrl() + lib.getPath())), local, lib.getPath(), true));
                    continue;
                }
                local = new File(root, "libraries/" + lib.getPathNatives());
                if (local.exists() && !forceUpdate.booleanValue()) continue;
                list.add(new DownloadInfo(new URL(lib.getUrl() + lib.getPathNatives()), local, lib.getPathNatives()));
            }
            Logger.logDebug("Checking pack libararies");
            ModPack pack = ModPack.getSelectedPack();
            File packDir = new File(installDir, pack.getDir());
            File gameDir = new File(packDir, "minecraft");
            File libDir = new File(installDir, "libraries");
            if (!pack.getDir().equals("mojang_vanilla") && new File(gameDir, "pack.json").exists()) {
                Version packjson = JsonFactory.loadVersion(new File(gameDir, "pack.json"));
                for (Library lib : packjson.getLibraries()) {
                    local = new File(root, "libraries/" + lib.getPath());
                    if (new File(libDir, lib.getPath()).exists()) continue;
                    if (lib.checksums != null) {
                        list.add(new DownloadInfo(new URL(lib.getUrl() + lib.getPath()), local, lib.getPath(), lib.checksums, "sha1", DownloadInfo.DLType.NONE, DownloadInfo.DLType.NONE));
                        continue;
                    }
                    if (lib.download == null || !lib.download.booleanValue()) continue;
                    list.add(new DownloadInfo(new URL(lib.getUrl() + lib.getPath()), local, lib.getPath()));
                }
            }
            if ((test = new File(root, "assets/READ_ME_I_AM_VERY_IMPORTANT.txt")).exists()) {
                Logger.logDebug("Moving old format");
                File assets = new File(root, "assets");
                Set<File> old = FileUtils.listFiles(assets);
                File objects = new File(assets, "objects");
                String[] skip = new String[]{objects.getAbsolutePath(), new File(assets, "indexes").getAbsolutePath(), new File(assets, "virtual").getAbsolutePath()};
                for (File f : old) {
                    String path = f.getAbsolutePath();
                    boolean move = true;
                    for (String prefix : skip) {
                        if (!path.startsWith(prefix)) continue;
                        move = false;
                    }
                    if (!move) continue;
                    String hash = DownloadUtils.fileSHA(f);
                    File cache = new File(objects, hash.substring(0, 2) + "/" + hash);
                    Logger.logInfo("Caching Asset: " + hash + " - " + f.getAbsolutePath().replace(assets.getAbsolutePath(), ""));
                    if (!cache.exists()) {
                        cache.getParentFile().mkdirs();
                        f.renameTo(cache);
                    }
                    f.delete();
                }
                List<File> dirs = FileUtils.listDirs(assets);
                for (File dir : dirs) {
                    if (dir.listFiles().length != 0) continue;
                    dir.delete();
                }
            }
            Logger.logDebug("Checking minecraft assets");
            url = new URL("https://s3.amazonaws.com/Minecraft.Download/" + "indexes/{INDEX}.json".replace("{INDEX}", version.getAssets()));
            json = new File(root, "assets/indexes/{INDEX}.json".replace("{INDEX}", version.getAssets()));
            DownloadUtils.downloadToFile(url, json, 3);
            if (!json.exists()) {
                Logger.logError("asset JSON not found");
                return null;
            }
            AssetIndex index = JsonFactory.loadAssetIndex(json);
            Benchmark.start("threading");
            long size = list.size();
            Logger.logDebug("Starting TaskHandler to check MC assets");
            Parallel.TaskHandler<DownloadInfo> th = new Parallel.ForEach(index.objects.entrySet()).withFixedThreads(2 * OSUtils.getNumCores()).apply(new Parallel.F<Map.Entry<String, AssetIndex.Asset>, DownloadInfo>(){

                @Override
                public DownloadInfo apply(Map.Entry<String, AssetIndex.Asset> e) {
                    try {
                        String name = e.getKey();
                        AssetIndex.Asset asset = e.getValue();
                        String path = asset.hash.substring(0, 2) + "/" + asset.hash;
                        File local = new File(root, "assets/objects/" + path);
                        if (local.exists() && !asset.hash.equals(DownloadUtils.fileSHA(local))) {
                            local.delete();
                        }
                        if (!local.exists()) {
                            return new DownloadInfo(new URL("http://resources.download.minecraft.net/" + path), local, name, Lists.newArrayList(asset.hash), "sha1");
                        }
                    }
                    catch (Exception ex) {
                        Logger.logError("Asset hash check failed", ex);
                    }
                    return null;
                }
            });
            Collection<DownloadInfo> tmp = th.values();
            list.addAll(tmp);
            th.shutdown();
            Benchmark.logBenchAs("threading", "parallel asset check");
            return list;
        }
        catch (Exception e) {
            Logger.logError("Error while gathering assets", e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void launchMinecraft(String installDir, ModPack pack, LoginResponse resp, boolean isLegacy) {
        try {
            File packDir = new File(installDir, pack.getDir());
            String gameFolder = installDir + File.separator + pack.getDir() + File.separator + "minecraft";
            File gameDir = new File(packDir, "minecraft");
            File assetDir = new File(installDir, "assets");
            File libDir = new File(installDir, "libraries");
            File natDir = new File(packDir, "natives");
            String packVer = Settings.getSettings().getPackVer(pack.getDir());
            Logger.logInfo("Setting up native libraries for " + pack.getName() + " v " + packVer + " MC " + pack.getMcVersion(packVer));
            if (!gameDir.exists()) {
                gameDir.mkdirs();
            }
            if (natDir.exists()) {
                natDir.delete();
            }
            natDir.mkdirs();
            if (isLegacy) {
                MCInstaller.extractLegacy();
            }
            Version base = JsonFactory.loadVersion(new File(installDir, "versions/{MC_VER}/{MC_VER}.json".replace("{MC_VER}", pack.getMcVersion(packVer))));
            byte[] buf = new byte[1024];
            for (Library lib : base.getLibraries()) {
                if (lib.natives == null) continue;
                Iterator<Library> local = new File(libDir, lib.getPathNatives());
                ZipInputStream input = null;
                try {
                    input = new ZipInputStream(new FileInputStream((File)((Object)local)));
                    ZipEntry entry = input.getNextEntry();
                    while (entry != null) {
                        String name = entry.getName();
                        if (lib.extract == null || !lib.extract.exclude(name)) {
                            int n;
                            File output = new File(natDir, name);
                            output.getParentFile().mkdirs();
                            FileOutputStream out = new FileOutputStream(output);
                            while ((n = input.read(buf, 0, 1024)) > -1) {
                                out.write(buf, 0, n);
                            }
                            out.close();
                        }
                        input.closeEntry();
                        entry = input.getNextEntry();
                    }
                }
                catch (Exception e) {
                    ErrorUtils.tossError("Error extracting native libraries");
                    Logger.logError("", e);
                }
                finally {
                    try {
                        input.close();
                    }
                    catch (IOException e) {}
                }
            }
            ArrayList<File> classpath = new ArrayList<File>();
            Version packjson = new Version();
            if (!pack.getDir().equals("mojang_vanilla")) {
                if (isLegacy) {
                    MCInstaller.extractLegacyJson(new File(gameDir, "pack.json"));
                }
                if (new File(gameDir, "pack.json").exists()) {
                    packjson = JsonFactory.loadVersion(new File(gameDir, "pack.json"));
                    for (Library lib : packjson.getLibraries()) {
                        classpath.add(new File(libDir, lib.getPath()));
                    }
                }
            } else {
                packjson = base;
            }
            if (!isLegacy) {
                classpath.add(new File(installDir, "versions/{MC_VER}/{MC_VER}.jar".replace("{MC_VER}", pack.getMcVersion(packVer))));
            } else {
                FileUtils.copyFile(new File(installDir, "versions/{MC_VER}/{MC_VER}.jar".replace("{MC_VER}", pack.getMcVersion(packVer))), new File(gameDir, "bin/minecraft.jar"));
                FileUtils.killMetaInf();
            }
            for (Library lib : base.getLibraries()) {
                classpath.add(new File(libDir, lib.getPath()));
            }
            Process minecraftProcess = MCLauncher.launchMinecraft(Settings.getSettings().getJavaPath(), gameFolder, assetDir, natDir, classpath, packjson.mainClass != null ? packjson.mainClass : base.mainClass, packjson.minecraftArguments != null ? packjson.minecraftArguments : base.minecraftArguments, packjson.assets != null ? packjson.assets : base.getAssets(), Settings.getSettings().getRamMax(), pack.getMaxPermSize(), pack.getMcVersion(packVer), resp.getAuth(), isLegacy);
            LaunchFrame.MCRunning = true;
            if (LaunchFrame.con != null) {
                LaunchFrame.con.minecraftStarted();
            }
            StreamLogger.prepare(minecraftProcess.getInputStream(), new LogEntry().level(LogLevel.UNKNOWN));
            String[] ignore = new String[]{"Session ID is token"};
            StreamLogger.setIgnore(ignore);
            StreamLogger.doStart();
            TrackerUtils.sendPageView(ModPack.getSelectedPack().getName() + " Launched", ModPack.getSelectedPack().getName());
            try {
                Thread.sleep(1500L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            try {
                minecraftProcess.exitValue();
            }
            catch (IllegalThreadStateException e) {
                LaunchFrame.getInstance().setVisible(false);
                LaunchFrame.setProcMonitor(ProcessMonitor.create(minecraftProcess, new Runnable(){

                    @Override
                    public void run() {
                        if (!Settings.getSettings().getKeepLauncherOpen()) {
                            System.exit(0);
                        } else {
                            if (LaunchFrame.con != null) {
                                LaunchFrame.con.minecraftStopped();
                            }
                            LaunchFrame launchFrame = LaunchFrame.getInstance();
                            launchFrame.setVisible(true);
                            LaunchFrame.getInstance().getEventBus().post(new EnableObjectsEvent());
                            try {
                                Settings.getSettings().load(new FileInputStream(Settings.getSettings().getConfigFile()));
                                LaunchFrame.getInstance().tabbedPane.remove(1);
                                LaunchFrame.getInstance().optionsPane = new OptionsPane(Settings.getSettings());
                                LaunchFrame.getInstance().tabbedPane.add((Component)LaunchFrame.getInstance().optionsPane, 1);
                                LaunchFrame.getInstance().tabbedPane.setIconAt(1, LauncherStyle.getCurrentStyle().filterHeaderIcon(this.getClass().getResource("/image/tabs/options.png")));
                            }
                            catch (Exception e1) {
                                Logger.logError("Failed to reload settings after launcher closed", e1);
                            }
                        }
                        LaunchFrame.MCRunning = false;
                    }
                }));
            }
        }
        catch (Exception e) {
            Logger.logError("Error while running launchMinecraft()", e);
        }
    }

    public static void installMods(String modPackName) throws IOException {
        String installpath = Settings.getSettings().getInstallPath();
        String temppath = OSUtils.getCacheStorageLocation();
        ModPack pack = LaunchFrame.currentPane == LaunchFrame.Panes.THIRDPARTY ? ModPack.getPack(LaunchFrame.getInstance().thirdPartyPane.getSelectedThirdPartyModIndex()) : ModPack.getPack(LaunchFrame.getInstance().modPacksPane.getSelectedFTBModIndex());
        String packDir = pack.getDir();
        Logger.logInfo("dirs mk'd");
        File source = new File(temppath, "ModPacks/" + packDir + "/.minecraft");
        if (!source.exists()) {
            source = new File(temppath, "ModPacks/" + packDir + "/minecraft");
        }
        Logger.logDebug("install path: " + installpath);
        Logger.logDebug("temp path: " + temppath);
        Logger.logDebug("source: " + source);
        Logger.logDebug("packDir: " + packDir);
        FileUtils.copyFolder(source, new File(installpath, packDir + "/minecraft/"));
        FileUtils.copyFolder(new File(temppath, "ModPacks/" + packDir + "/instMods/"), new File(installpath, packDir + "/instMods/"));
        FileUtils.copyFolder(new File(temppath, "ModPacks/" + packDir + "/libraries/"), new File(installpath, "/libraries/"), false);
    }

    public static void extractLegacy() {
        try {
            File f = new File(Settings.getSettings().getInstallPath() + File.separator + "libraries" + File.separator + "net.ftb.legacylaunch.FTBLegacyLaunch".replace(".", File.separator) + File.separator + "0.0.1" + File.separator + "FTBLegacyLaunch-0.0.1.jar");
            if (!new File(f.getParent()).exists()) {
                new File(f.getParent()).mkdirs();
            }
            if (f.exists()) {
                f.delete();
            }
            URL u = LaunchFrame.class.getResource("/launch/FTBLegacyLaunch-0.0.1.jar");
            org.apache.commons.io.FileUtils.copyURLToFile(u, f);
        }
        catch (Exception e) {
            Logger.logError("Error extracting legacy launch to maven directory");
        }
    }

    public static void extractLegacyJson(File newLoc) {
        try {
            if (!new File(newLoc.getParent()).exists()) {
                new File(newLoc.getParent()).mkdirs();
            }
            if (newLoc.exists()) {
                newLoc.delete();
            }
            URL u = LaunchFrame.class.getResource("/launch/legacypack.json");
            org.apache.commons.io.FileUtils.copyURLToFile(u, newLoc);
        }
        catch (Exception e) {
            Logger.logError("Error extracting legacy json to maven directory");
        }
    }
}

